<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>

    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> {{ $data['page'] }}</h3>
                                <a href="/member" class="btn btn-primary float-right mb-3"><i
                                        class="fa fa-reply mr-2"></i> Kembali
                                </a>
                            </div>
                            <form action="{{ route('member.store') }}" method="post">
                                @csrf
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Kode member
                                                </label>
                                                <div class="col-sm-8">
                                                    <input type="text" name="kd_member" class="form-control"
                                                        value="{{ $kd }}" placeholder="Kode Member" readonly>
                                                    @error('kd_member')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Nama member
                                                </label>
                                                <div class="col-sm-8">
                                                    <input type="text" name="nm_member" class="form-control"
                                                        placeholder="Nama Member" required
                                                        value="{{ old('nm_member') }}">
                                                    @error('nm_member')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Hp member
                                                </label>
                                                <div class="col-sm-8">
                                                    <input type="text" name="hp_member" class="form-control"
                                                        placeholder="Hp Member" required value="{{ old('hp_member') }}">
                                                    @error('hp_member')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Email member
                                                </label>
                                                <div class="col-sm-8">
                                                    <input type="text" name="email_member" class="form-control"
                                                        placeholder="Email Member" required
                                                        value="{{ old('email_member') }}">
                                                    @error('email_member')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Jenis
                                                    Kelamin
                                                </label>
                                                <div class="col-sm-4 mt-2">
                                                    <div class="custom-control custom-radio">
                                                        <input class="custom-control-input" type="radio"
                                                            id="laki" value="L" name="kelamin_member" checked
                                                            {{ old('kelamin_member') == 'L' ? 'checked' : '' }}>
                                                        <label for="laki" class="custom-control-label ">Laki-Laki
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4 mt-2">
                                                    <div class="custom-control custom-radio">
                                                        <input class="custom-control-input" type="radio"
                                                            id="perempuan" value="P" name="kelamin_member"
                                                            {{ old('kelamin_member') == 'P' ? 'checked' : '' }}>
                                                        <label for="perempuan" class="custom-control-label ">Perempuan
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <hr>
                                            <h4>MEMBER LOGIN</h4>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Username
                                                </label>
                                                <div class="col-sm-8">
                                                    <input type="text" name="username" class="form-control"
                                                        placeholder="Username" required value="{{ old('username') }}">
                                                    @error('username')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Password
                                                    (min 6
                                                    Digit)
                                                </label>
                                                <div class="col-sm-8">
                                                    <input type="password" name="password" class="form-control"
                                                        placeholder="Password" required value="{{ old('password') }}">
                                                    @error('password')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                        </div>

                                        <div class="col-md-6">

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Alamat
                                                </label>
                                                <div class="col-sm-8">
                                                    <textarea name="alamat" id="" class="form-control" placeholder="Jl. ....">{{ old('alamat') }}</textarea>
                                                    @error('alamat')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror
                                                </div>
                                            </div>

                                            <hr>
                                            <h4>BELANJA ONLINE</h4>

                                            <div class="form-group row">
                                                <label for="inputPassword3" class="col-sm-4 col-form-label">Harga
                                                    Ongkir
                                                </label>
                                                <div class="col-sm-8">
                                                    <select name="ongkir" id="ongkir" class="form-control">
                                                        <option value="">Pilih kode ongkir</option>
                                                        @foreach ($ongkir as $o)
                                                            <option value="{{ $o->id }}">{{ $o->kd_ongkir }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @error('ongkir')
                                                        <small class="text-danger mt-2">
                                                            {{ $message }}
                                                        </small>
                                                    @enderror


                                                    <div class="row mt-3">
                                                        <div class="col-md-12">
                                                            <label for="">Daerah / Rute</label>
                                                            <textarea id="alamat" class="form-control " placeholder="Jl. ...." readonly></textarea>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="">Berat (Kg)</label>
                                                            <input type="text" name="berat" id="berat"
                                                                class="form-control" placeholder="0 Kg" readonly>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="">Harga (Kg)</label>
                                                            <input type="text " name="harga" id="harga"
                                                                class="form-control" placeholder="Rp. 0" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="card-footer">
                                    <button type="reset" class="btn btn-default">Reset</button>
                                    <button type="submit" class="btn btn-primary float-right"><i
                                            class="fa fa-save"></i>
                                        Simpan</button>
                                </div>
                            </form>

                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->

                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->

    <x-slot:foot>
        <script>
            $('#ongkir').change(function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $(this).val();
                $.ajax({
                    type: 'POST',
                    url: '/view-ongkir',
                    dataType: 'JSON',
                    data: {
                        id: id,
                        _token: token,
                    },
                    success: function(data) {
                        $('#alamat').val(data.alamat);
                        $('#berat').val(data.berat);
                        $('#harga').val(data.harga);
                    }
                });
            })
        </script>
    </x-slot:foot>
</x-kasir.contents>
